function [fitresult, gof] = Create_Surface_Fit_4(global_x_r_log, global_y_r_log, global_f_r_log)
%CREATESURFACEFIT(GLOBAL_X_R_LOG,GLOBAL_Y_R_LOG,GLOBAL_F_R_LOG)
%  Fit surface to data.
%
%  Data for 'untitled fit 1' fit:
%      X Input : global_x_r_log
%      Y Input : global_y_r_log
%      Z Output: global_f_r_log
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.

%  Auto-generated by MATLAB on 07-Apr-2011 00:19:26


%% Fit: 'untitled fit 1'.
[xInput, yInput, zOutput] = prepareSurfaceData( global_x_r_log, global_y_r_log, global_f_r_log );

% Set up fittype and options.
ft = fittype( '(bottom1 + (top1 - bottom1) / (1+10^((LogEC50_1 - x)))) * Bottom + (Top-Bottom)/(1+10^((LogIC50-y)*HillSlope))', 'indep', {'x', 'y'}, 'depend', 'z' );
opts = fitoptions( ft );
opts.Algorithm = 'Levenberg-Marquardt';
opts.Display = 'Off';
opts.Lower = [-Inf -Inf -Inf -Inf -Inf -Inf -Inf];
opts.StartPoint = [0.764541043630959 0.153924903420242 2 0.553746204106755 0.756495610611271 0.657985137875156 0.594990622577131];
opts.Upper = [Inf Inf Inf Inf Inf Inf Inf];

% Fit model to data.
[fitresult, gof] = fit( [xInput, yInput], zOutput, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, [xInput, yInput], zOutput );
legend( h, 'untitled fit 1', 'global_f_r_log vs. global_x_r_log, global_y_r_log', 'Location', 'NorthEast' );
% Label axes
xlabel( 'global_x_r_log' );
ylabel( 'global_y_r_log' );
zlabel( 'global_f_r_log' );
grid on
view( -133.5, 40 );


